<?php

namespace App\Http\Livewire\Auth;

use App\Models\User;
use Livewire\Component;
use Session;

class Login extends Component
{

    public $email = '';
    public $password = '';
    public $remember_me = false;

    protected $rules = [
        'email' => 'required|email',
        'password' => 'required|min:6',
    ];

    //This mounts the default credentials for the admin. Remove this section if you want to make it public.
    public function mount()
    {
        if (auth()->user()) {
            if(auth()->user()->user_type == 'admin')
            {
                return redirect()->intended('/admin/dashboard');
            }elseif(auth()->user()->user_type = 'user')
            {
                return redirect()->intended('user/dashboard');
            }
        }
    }

    public function login()
    {

        $credentials = $this->validate();
        if (auth()->attempt(['email' => $this->email, 'password' => $this->password], $this->remember_me)) {
            $user = User::where(['email' => $this->email])->first();
            auth()->login($user, $this->remember_me);

            if($user->user_type == 'admin')
            {
                return redirect()->intended('/admin/dashboard');
            }else{

                return redirect()->intended('/user/dashboard');
            }


        } else {
            return $this->addError('email', trans('auth.failed'));
        }
    }

    public function render()
    {
        return view('livewire.auth.login')
                ->layout('layouts.root');
    }
}
