<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Option;
use App\Models\Term;
use App\Models\Termmeta;

class OptionTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $options = array(
            array('id' => '1','key' => 'currency_symbol','value' => '$','created_at' => '2022-04-22 05:27:45','updated_at' => '2022-04-22 05:27:45'),
            array('id' => '2','key' => 'site_settings','value' => '{"copyright":"Copyright \\u00a9 2022. All Rights Reserved.","site_logo":"logo\\/ncu8VzcYrtHHMqAsEcBlpjprXpcfsTkZE6hg9Z6R.png","site_favicon":"favicon\\/FWBYe9LH2HHNhyPBCYJbBW3udXGFuEFyoldnztWW.png","case_title":"Explore All Use Cases","case_description":"Language models can be used to generate written content such as stories, articles, and poetry. \\n","how_it_works_title":"How It Works","brand_title":"Trusted by 1,000,000+ marketing teams, agencies and freelancers. 10,000+ 5-star ratings.","plan_title":"Pricing Plans"}','created_at' => '2022-04-22 14:16:56','updated_at' => '2023-01-21 11:57:28'),
            array('id' => '3','key' => 'hero_data','value' => '{"hero_title":"Best Ai Writer For Creating","hero_img":"LMxkU7Mh4j22YZP2vAv8vPIVh8J8teWQQXfoxDQU.png","description":"Our advanced language models will help you generate creative content, translate text, summarize information, and more.","button_title":"Start Writing For Free","button_url":"\\/register"}','created_at' => '2023-01-15 21:20:55','updated_at' => '2023-01-21 12:01:45'),
            array('id' => '4','key' => 'howItWorks','value' => '{"step1_title":"Choose Your UseCase & Fill Up.","step1_des":"This feature streamlines the process of using AI Writing, making it simple and intuitive for users to accomplish their desired task.","step2_title":"Wow! It\'s generate Your Content.","step2_des":"The AI Writing model will then analyze the input and generate a unique and creative piece of content based on the user\'s specifications.\\n\\n","step3_title":"Edit, polish, and publish","step3_des":"Use AiWrite editor to rewrite paragraphs and polish up sentences. \\n","step1_image":"Mf8DJIPGpEyXO0YEVxWA01KKQ85i5dAbeONXQWaL.png","step2_image":"6OwHAvzKj9s3ZjRIiocFZHGzfB6KMMZs4oBjv1n9.png"}','created_at' => '2023-01-15 21:21:13','updated_at' => '2023-01-21 12:28:11'),
            array('id' => '5','key' => 'level','value' => '{"title":"Ready to level-up?","description":"Write 10x faster, engage your audience, & never struggle with the blank page again.\\n\\n","button_title":"Get Started For Free","button_url":"\\/register","level_list1":"No credit card required","level_list2":"7-day trial of Pro","level_list3":"90+ content types to explore"}','created_at' => '2023-01-15 21:21:27','updated_at' => '2023-01-21 12:29:41')
        );

        Option::insert($options);

        $terms = array(
            array('id' => '1','user_id' => '2','name' => 'Exploring the Future of AI-Driven Content Creation','slug' => 'exploring-the-future-of-ai-driven-content-creation','status' => 'approved','type' => 'blog','created_at' => '2023-01-20 14:29:46','updated_at' => '2023-01-21 15:39:06'),
            array('id' => '2','user_id' => '2','name' => '1E4pmy8PegsdZVmK6efnJp44mgFIjNcKKjUY5U2u.png','slug' => '1e4pmy8pegsdzvmk6efnjp44mgfijnckkjuy5u2upng','status' => 'approved','type' => 'brand','created_at' => '2023-01-21 12:05:25','updated_at' => '2023-01-21 12:05:25'),
            array('id' => '3','user_id' => '2','name' => '2gm2XyP3MjriW0WUXwXT7ZPEmYf9mSYGmGtDWu60.png','slug' => '2gm2xyp3mjriw0wuxwxt7zpemyf9msygmgtdwu60png','status' => 'approved','type' => 'brand','created_at' => '2023-01-21 12:05:31','updated_at' => '2023-01-21 12:05:31'),
            array('id' => '4','user_id' => '2','name' => 'iRl157pTSnv8spK7m3D39rAwCbBUllWzCzyYAWvM.png','slug' => 'irl157ptsnv8spk7m3d39rawcbbullwzczyyawvmpng','status' => 'approved','type' => 'brand','created_at' => '2023-01-21 12:05:38','updated_at' => '2023-01-21 12:05:38'),
            array('id' => '5','user_id' => '2','name' => 'DQ7HS1K7OoGOtQ9LkaR44WWfFUqGdZYwmxSnrE5r.png','slug' => 'dq7hs1k7oogotq9lkar44wwffuqgdzywmxsnre5rpng','status' => 'approved','type' => 'brand','created_at' => '2023-01-21 12:05:44','updated_at' => '2023-01-21 12:05:44'),
            array('id' => '6','user_id' => '2','name' => '8lP9L8ufgY3jUvCUwoxA7KYgN9dFOfzsMscv276o.png','slug' => '8lp9l8ufgy3juvcuwoxa7kygn9dfofzsmscv276opng','status' => 'approved','type' => 'brand','created_at' => '2023-01-21 12:06:01','updated_at' => '2023-01-21 12:06:01'),
            array('id' => '7','user_id' => '2','name' => 'Blog Idea & Outline','slug' => 'blog-idea-outline','status' => 'approved','type' => 'useCase','created_at' => '2023-01-21 12:42:22','updated_at' => '2023-01-21 12:42:22'),
            array('id' => '8','user_id' => '2','name' => 'Blog Section Writing','slug' => 'blog-section-writing','status' => 'approved','type' => 'useCase','created_at' => '2023-01-21 12:44:59','updated_at' => '2023-01-21 12:44:59'),
            array('id' => '9','user_id' => '2','name' => 'Business Ideas','slug' => 'business-ideas','status' => 'approved','type' => 'useCase','created_at' => '2023-01-21 12:46:52','updated_at' => '2023-01-21 12:46:52'),
            array('id' => '10','user_id' => '2','name' => 'Cover Letter','slug' => 'cover-letter','status' => 'approved','type' => 'useCase','created_at' => '2023-01-21 12:50:22','updated_at' => '2023-01-21 12:50:22'),
            array('id' => '11','user_id' => '2','name' => 'Facebook, Twitter Ads','slug' => 'facebook-twitter-ads','status' => 'approved','type' => 'useCase','created_at' => '2023-01-21 12:53:34','updated_at' => '2023-01-21 13:01:46'),
            array('id' => '12','user_id' => '2','name' => 'Google Search Ads','slug' => 'google-search-ads','status' => 'approved','type' => 'useCase','created_at' => '2023-01-21 12:54:36','updated_at' => '2023-01-21 12:54:36'),
            array('id' => '13','user_id' => '2','name' => 'Post & Caption Ideas','slug' => 'post-caption-ideas','status' => 'approved','type' => 'useCase','created_at' => '2023-01-21 12:55:52','updated_at' => '2023-01-21 12:55:52'),
            array('id' => '14','user_id' => '2','name' => 'Product Description','slug' => 'product-description','status' => 'approved','type' => 'useCase','created_at' => '2023-01-21 12:57:26','updated_at' => '2023-01-21 12:57:26'),
            array('id' => '15','user_id' => '2','name' => 'SEO Meta Description','slug' => 'seo-meta-description','status' => 'approved','type' => 'useCase','created_at' => '2023-01-21 12:58:11','updated_at' => '2023-01-21 12:58:11'),
            array('id' => '16','user_id' => '2','name' => 'SEO Meta Title','slug' => 'seo-meta-title','status' => 'approved','type' => 'useCase','created_at' => '2023-01-21 12:59:18','updated_at' => '2023-01-21 12:59:18'),
            array('id' => '17','user_id' => '2','name' => 'Video Description','slug' => 'video-description','status' => 'approved','type' => 'useCase','created_at' => '2023-01-21 13:00:18','updated_at' => '2023-01-21 13:00:18'),
            array('id' => '18','user_id' => '2','name' => 'Video Idea','slug' => 'video-idea','status' => 'approved','type' => 'useCase','created_at' => '2023-01-21 13:00:56','updated_at' => '2023-01-21 13:00:56'),
            array('id' => '19','user_id' => '2','name' => 'The Next Frontier in Digital Content','slug' => 'the-next-frontier-in-digital-content','status' => 'approved','type' => 'blog','created_at' => '2023-01-21 15:46:59','updated_at' => '2023-01-21 15:48:33'),
            array('id' => '20','user_id' => '2','name' => 'Unlocking the Power of AI for Content','slug' => 'unlocking-the-power-of-ai-for-content','status' => 'approved','type' => 'blog','created_at' => '2023-01-21 15:47:56','updated_at' => '2023-01-21 15:47:56'),
            array('id' => '21','user_id' => '2','name' => 'Home','slug' => 'home','status' => 'approved','type' => 'seo','created_at' => '2023-01-22 17:53:05','updated_at' => '2023-01-22 18:12:47'),
            array('id' => '22','user_id' => '2','name' => 'Pricing Plans','slug' => 'pricing','status' => 'approved','type' => 'seo','created_at' => '2023-01-22 17:53:21','updated_at' => '2023-01-22 18:15:32'),
            array('id' => '23','user_id' => '2','name' => 'Blogs','slug' => 'blogs','status' => 'approved','type' => 'seo','created_at' => '2023-01-22 17:53:40','updated_at' => '2023-01-22 18:16:17'),
            array('id' => '24','user_id' => '2','name' => 'Contact','slug' => 'contact','status' => 'approved','type' => 'seo','created_at' => '2023-01-22 17:53:52','updated_at' => '2023-01-22 18:16:45')
          );


        Term::insert($terms);

        $termmetas = array(
            array('id' => '1','term_id' => '1','key' => 'blogmeta','value' => '{"short_content":"AI content writing refers to the use of artificial intelligence technology to generate written content, such as articles, blog posts, product descriptions, and more. This technology utilizes natural language processing (NLP) algorithms to analyze and understand human language, and then generates written content that is similar to human-written content. It can be used to automate repetitive or time-consuming tasks, such as content generation and editing, and can even improve the overall quality and efficiency of content creation.","description":"Exploring the Future of AI-Driven Content Creation\\" is a blog post that delves into the rapidly evolving world of artificial intelligence and its impact on the field of content creation. The post begins by defining what AI content writing is, and why it\'s becoming increasingly important. It then goes on to examine how AI content writing works, and the different types of AI-generated content that are currently available.\\n\\nThe post also explores the benefits of using AI for content creation, including increased efficiency, cost savings, and improved content quality. Real-life examples and case studies are provided to illustrate the practical applications of AI-driven content creation across various industries. Additionally, the post looks into the impact of AI content writing on SEO and Digital Marketing.\\n\\nThe post concludes by discussing the future of AI content writing, including advancements in AI technology and its potential in content creation, ethical considerations and predictions for the future of AI content writing. Overall, this post aims to provide readers with an in-depth understanding of the current state of AI-driven content creation and its future possibilities, and to inspire further research and exploration into this exciting field.","preview":"vLWmjpK1X5tpvQr6lJXCyEsd67Y5NPxPxjbE9A4e.png"}','created_at' => '2023-01-20 14:29:46','updated_at' => '2023-01-21 15:39:06'),
            array('id' => '2','term_id' => '7','key' => 'useCaseMeta','value' => '{"description":"It is a long established fact that a reader will be distracted. ","icon":"ri-edit-line"}','created_at' => '2023-01-21 12:42:22','updated_at' => '2023-01-21 12:43:31'),
            array('id' => '3','term_id' => '8','key' => 'useCaseMeta','value' => '{"description":"It is a long established fact that a reader will be distracted.\\n\\n","icon":"ri-layout-fill"}','created_at' => '2023-01-21 12:44:59','updated_at' => '2023-01-21 12:44:59'),
            array('id' => '4','term_id' => '9','key' => 'useCaseMeta','value' => '{"description":"It is a long established fact that a reader will be distracted.\\n\\n","icon":"ri-briefcase-5-fill"}','created_at' => '2023-01-21 12:46:52','updated_at' => '2023-01-21 12:52:41'),
            array('id' => '5','term_id' => '10','key' => 'useCaseMeta','value' => '{"description":"It is a long established fact that a reader will be distracted.","icon":"ri-article-line"}','created_at' => '2023-01-21 12:50:22','updated_at' => '2023-01-21 12:50:22'),
            array('id' => '6','term_id' => '11','key' => 'useCaseMeta','value' => '{"description":"It is a long established fact that a reader will be distracted.\\n\\n","icon":"ri-twitter-fill"}','created_at' => '2023-01-21 12:53:34','updated_at' => '2023-01-21 13:01:46'),
            array('id' => '7','term_id' => '12','key' => 'useCaseMeta','value' => '{"description":"It is a long established fact that a reader will be distracted.\\n\\n","icon":"ri-google-fill"}','created_at' => '2023-01-21 12:54:36','updated_at' => '2023-01-21 12:54:36'),
            array('id' => '8','term_id' => '13','key' => 'useCaseMeta','value' => '{"description":"It is a long established fact that a reader will be distracted.\\n\\n","icon":"ri-quill-pen-fill"}','created_at' => '2023-01-21 12:55:52','updated_at' => '2023-01-21 12:55:52'),
            array('id' => '9','term_id' => '14','key' => 'useCaseMeta','value' => '{"description":"It is a long established fact that a reader will be distracted.\\n\\n","icon":"ri-newspaper-line"}','created_at' => '2023-01-21 12:57:26','updated_at' => '2023-01-21 12:57:26'),
            array('id' => '10','term_id' => '15','key' => 'useCaseMeta','value' => '{"description":"It is a long established fact that a reader will be distracted.\\n\\n","icon":"ri-file-search-fill"}','created_at' => '2023-01-21 12:58:11','updated_at' => '2023-01-21 12:58:48'),
            array('id' => '11','term_id' => '16','key' => 'useCaseMeta','value' => '{"description":"It is a long established fact that a reader will be distracted.\\n\\n\\n\\n","icon":"ri-search-eye-line"}','created_at' => '2023-01-21 12:59:18','updated_at' => '2023-01-21 12:59:18'),
            array('id' => '12','term_id' => '17','key' => 'useCaseMeta','value' => '{"description":"It is a long established fact that a reader will be distracted.\\n\\n","icon":"ri-youtube-fill"}','created_at' => '2023-01-21 13:00:18','updated_at' => '2023-01-21 13:00:18'),
            array('id' => '13','term_id' => '18','key' => 'useCaseMeta','value' => '{"description":"It is a long established fact that a reader will be distracted.\\n","icon":"ri-video-add-fill"}','created_at' => '2023-01-21 13:00:56','updated_at' => '2023-01-21 13:00:56'),
            array('id' => '14','term_id' => '19','key' => 'blogmeta','value' => '{"short_content":"AI content writing refers to the use of artificial intelligence technology to generate written content, such as articles, blog posts, product descriptions, and more. This technology utilizes natural language processing (NLP) algorithms to analyze and understand human language, and then generates written content that is similar to human-written content. It can be used to automate repetitive or time-consuming tasks, such as content generation and editing, and can even improve the overall quality and efficiency of content creation.\\n\\n","description":"Exploring the Future of AI-Driven Content Creation\\" is a blog post that delves into the rapidly evolving world of artificial intelligence and its impact on the field of content creation. The post begins by defining what AI content writing is, and why it\'s becoming increasingly important. It then goes on to examine how AI content writing works, and the different types of AI-generated content that are currently available. The post also explores the benefits of using AI for content creation, including increased efficiency, cost savings, and improved content quality. Real-life examples and case studies are provided to illustrate the practical applications of AI-driven content creation across various industries. Additionally, the post looks into the impact of AI content writing on SEO and Digital Marketing. The post concludes by discussing the future of AI content writing, including advancements in AI technology and its potential in content creation, ethical considerations and predictions for the future of AI content writing. Overall, this post aims to provide readers with an in-depth understanding of the current state of AI-driven content creation and its future possibilities, and to inspire further research and exploration into this exciting field.\\n\\n\\n","preview":"gvJYBQazixpPirwSxEoUh8dsm2dJYkX6k0iLpBU3.png"}','created_at' => '2023-01-21 15:46:59','updated_at' => '2023-01-21 15:46:59'),
            array('id' => '15','term_id' => '20','key' => 'blogmeta','value' => '{"short_content":"AI content writing refers to the use of artificial intelligence technology to generate written content, such as articles, blog posts, product descriptions, and more. This technology utilizes natural language processing (NLP) algorithms to analyze and understand human language, and then generates written content that is similar to human-written content. It can be used to automate repetitive or time-consuming tasks, such as content generation and editing, and can even improve the overall quality and efficiency of content creation.\\n\\n","description":"Exploring the Future of AI-Driven Content Creation\\" is a blog post that delves into the rapidly evolving world of artificial intelligence and its impact on the field of content creation. The post begins by defining what AI content writing is, and why it\'s becoming increasingly important. It then goes on to examine how AI content writing works, and the different types of AI-generated content that are currently available. The post also explores the benefits of using AI for content creation, including increased efficiency, cost savings, and improved content quality. Real-life examples and case studies are provided to illustrate the practical applications of AI-driven content creation across various industries. Additionally, the post looks into the impact of AI content writing on SEO and Digital Marketing. The post concludes by discussing the future of AI content writing, including advancements in AI technology and its potential in content creation, ethical considerations and predictions for the future of AI content writing. Overall, this post aims to provide readers with an in-depth understanding of the current state of AI-driven content creation and its future possibilities, and to inspire further research and exploration into this exciting field.\\n\\n\\n","preview":"qegtakXFdoXgFvI4dvtJEevSszuZKA2FzKhYdXF8.png"}','created_at' => '2023-01-21 15:47:56','updated_at' => '2023-01-21 15:47:56'),
            array('id' => '16','term_id' => '21','key' => 'seometa','value' => '{"meta_tag":"home, aiwrite","twitter_title":"AiWrite content writing tools","meta_description":"AI content writing is the use of artificial intelligence technology to generate written content. This can include written text for websites, articles, social media posts, product descriptions, and more. AI content writing typically uses natural language processing (NLP) and machine learning algorithms to analyze and understand text and then generate new text that is similar in style and tone. The goal of AI content writing is to produce high-quality, engaging, and relevant content that is consistent with a brand\'s voice and message."}','created_at' => '2023-01-22 17:53:05','updated_at' => '2023-01-22 18:14:54'),
            array('id' => '17','term_id' => '22','key' => 'seometa','value' => '{"meta_tag":"aiwrite, content","twitter_title":"AiWrite content writing tools","meta_description":"AI content writing is the use of artificial intelligence technology to generate written content. This can include written text for websites, articles, social media posts, product descriptions, and more. AI content writing typically uses natural language processing (NLP) and machine learning algorithms to analyze and understand text and then generate new text that is similar in style and tone. The goal of AI content writing is to produce high-quality, engaging, and relevant content that is consistent with a brand\'s voice and message."}','created_at' => '2023-01-22 17:53:21','updated_at' => '2023-01-22 18:15:32'),
            array('id' => '18','term_id' => '23','key' => 'seometa','value' => '{"meta_tag":"aiwrite, content","twitter_title":"AiWrite content writing tools","meta_description":"AI content writing is the use of artificial intelligence technology to generate written content. This can include written text for websites, articles, social media posts, product descriptions, and more. AI content writing typically uses natural language processing (NLP) and machine learning algorithms to analyze and understand text and then generate new text that is similar in style and tone. The goal of AI content writing is to produce high-quality, engaging, and relevant content that is consistent with a brand\'s voice and message."}','created_at' => '2023-01-22 17:53:40','updated_at' => '2023-01-22 18:16:17'),
            array('id' => '19','term_id' => '24','key' => 'seometa','value' => '{"meta_tag":"aiwrite, content","twitter_title":"AiWrite content writing tools","meta_description":"AI content writing is the use of artificial intelligence technology to generate written content. This can include written text for websites, articles, social media posts, product descriptions, and more. AI content writing typically uses natural language processing (NLP) and machine learning algorithms to analyze and understand text and then generate new text that is similar in style and tone. The goal of AI content writing is to produce high-quality, engaging, and relevant content that is consistent with a brand\'s voice and message."}','created_at' => '2023-01-22 17:53:52','updated_at' => '2023-01-22 18:16:45')
          );

        Termmeta::insert($termmetas);
    }
}
