/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */
import { GridSelection, LexicalEditor, LexicalNode, NodeSelection, RangeSelection } from 'lexical';
export declare function $getHtmlContent(editor: LexicalEditor): string;
export declare function $getLexicalContent(editor: LexicalEditor): null | string;
export declare function $insertDataTransferForPlainText(dataTransfer: DataTransfer, selection: RangeSelection | GridSelection): void;
export declare function $insertDataTransferForRichText(dataTransfer: DataTransfer, selection: RangeSelection | GridSelection, editor: LexicalEditor): void;
export declare function $insertGeneratedNodes(editor: LexicalEditor, nodes: Array<LexicalNode>, selection: RangeSelection | GridSelection): void;
export interface BaseSerializedNode {
    children?: Array<BaseSerializedNode>;
    type: string;
    version: number;
}
export declare function $generateJSONFromSelectedNodes<SerializedNode extends BaseSerializedNode>(editor: LexicalEditor, selection: RangeSelection | NodeSelection | GridSelection | null): {
    namespace: string;
    nodes: Array<SerializedNode>;
};
export declare function $generateNodesFromSerializedNodes(serializedNodes: Array<BaseSerializedNode>): Array<LexicalNode>;
export declare function copyToClipboard__EXPERIMENTAL(editor: LexicalEditor, event: null | ClipboardEvent): Promise<boolean>;
