/** @module @lexical/link */
/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */
import type { DOMConversionMap, EditorConfig, GridSelection, LexicalCommand, LexicalNode, NodeKey, NodeSelection, RangeSelection, SerializedElementNode } from 'lexical';
import { ElementNode, Spread } from 'lexical';
export declare type LinkAttributes = {
    rel?: null | string;
    target?: null | string;
};
export declare type SerializedLinkNode = Spread<{
    type: 'link';
    url: string;
    version: 1;
}, Spread<LinkAttributes, SerializedElementNode>>;
/** @noInheritDoc */
export declare class LinkNode extends ElementNode {
    /** @internal */
    __url: string;
    /** @internal */
    __target: null | string;
    /** @internal */
    __rel: null | string;
    static getType(): string;
    static clone(node: LinkNode): LinkNode;
    constructor(url: string, attributes?: LinkAttributes, key?: NodeKey);
    createDOM(config: EditorConfig): HTMLAnchorElement;
    updateDOM(prevNode: LinkNode, anchor: HTMLAnchorElement, config: EditorConfig): boolean;
    static importDOM(): DOMConversionMap | null;
    static importJSON(serializedNode: SerializedLinkNode | SerializedAutoLinkNode): LinkNode;
    exportJSON(): SerializedLinkNode | SerializedAutoLinkNode;
    getURL(): string;
    setURL(url: string): void;
    getTarget(): null | string;
    setTarget(target: null | string): void;
    getRel(): null | string;
    setRel(rel: null | string): void;
    insertNewAfter(selection: RangeSelection, restoreSelection?: boolean): null | ElementNode;
    canInsertTextBefore(): false;
    canInsertTextAfter(): false;
    canBeEmpty(): false;
    isInline(): true;
    extractWithChild(child: LexicalNode, selection: RangeSelection | NodeSelection | GridSelection, destination: 'clone' | 'html'): boolean;
}
export declare function $createLinkNode(url: string, attributes?: LinkAttributes): LinkNode;
export declare function $isLinkNode(node: LexicalNode | null | undefined): node is LinkNode;
export declare type SerializedAutoLinkNode = Spread<{
    type: 'autolink';
    version: 1;
}, SerializedLinkNode>;
export declare class AutoLinkNode extends LinkNode {
    static getType(): string;
    static clone(node: AutoLinkNode): AutoLinkNode;
    static importJSON(serializedNode: SerializedAutoLinkNode): AutoLinkNode;
    static importDOM(): null;
    exportJSON(): SerializedAutoLinkNode;
    insertNewAfter(selection: RangeSelection, restoreSelection?: boolean): null | ElementNode;
}
export declare function $createAutoLinkNode(url: string, attributes?: LinkAttributes): AutoLinkNode;
export declare function $isAutoLinkNode(node: LexicalNode | null | undefined): node is AutoLinkNode;
export declare const TOGGLE_LINK_COMMAND: LexicalCommand<string | ({
    url: string;
} & LinkAttributes) | null>;
export declare function toggleLink(url: null | string, attributes?: LinkAttributes): void;
