/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
'use strict';

var react = require('react');

/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */
const CAN_USE_DOM = typeof window !== 'undefined' && typeof window.document !== 'undefined' && typeof window.document.createElement !== 'undefined';

/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */
const useLayoutEffectImpl = CAN_USE_DOM ? react.useLayoutEffect : react.useEffect;
var useLayoutEffect = useLayoutEffectImpl;

/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */

function getTarget(eventName, rootElement) {
  return eventName === 'selectionchange' || eventName === 'keyup' || eventName === 'pointerup' || eventName === 'pointercancel' ? rootElement.ownerDocument : rootElement;
}

function isRootEditable(editor) {
  const rootElement = editor.getRootElement();
  return rootElement !== null && rootElement.contentEditable === 'true';
}

function useEditorEvents(events, editor) {
  useLayoutEffect(() => {
    const create = [];
    const destroy = [];

    for (let i = 0; i < events.length; i++) {
      const [eventName, handler] = events[i];

      const handlerWrapper = event => {
        if (isRootEditable(editor)) {
          handler(event, editor);
        }
      };

      create.push(rootElement => {
        getTarget(eventName, rootElement).addEventListener(eventName, handlerWrapper);
      });
      destroy.push(rootElement => {
        getTarget(eventName, rootElement).removeEventListener(eventName, handlerWrapper);
      });
    }

    return editor.registerRootListener((rootElement, prevRootElement) => {
      if (prevRootElement !== null) {
        destroy.forEach(fn => fn(prevRootElement));
      }

      if (rootElement !== null) {
        create.forEach(fn => fn(rootElement));
      }
    });
  }, [editor, events]);
}

/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */
function useLexicalEditorEvents(events, editor) {
  useEditorEvents(events, editor);
}

exports.useLexicalEditorEvents = useLexicalEditorEvents;
