/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */
import type { Doc } from 'yjs';
import { WebsocketProvider } from 'y-websocket';
import { InitialEditorStateType } from './LexicalComposer';
import { CursorsContainerRef } from './shared/useYjsCollaboration';
export declare function CollaborationPlugin({ id, providerFactory, shouldBootstrap, username, cursorColor, cursorsContainerRef, initialEditorState, }: {
    id: string;
    providerFactory: (id: string, yjsDocMap: Map<string, Doc>) => WebsocketProvider;
    shouldBootstrap: boolean;
    username?: string;
    cursorColor?: string;
    cursorsContainerRef?: CursorsContainerRef;
    initialEditorState?: InitialEditorStateType;
}): JSX.Element;
