/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
'use strict';

var LexicalComposerContext = require('@lexical/react/LexicalComposerContext');
var React = require('react');

/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */
const CAN_USE_DOM = typeof window !== 'undefined' && typeof window.document !== 'undefined' && typeof window.document.createElement !== 'undefined';

/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */
const useLayoutEffectImpl = CAN_USE_DOM ? React.useLayoutEffect : React.useEffect;
var useLayoutEffect = useLayoutEffectImpl;

/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */
function ContentEditable({
  ariaActiveDescendantID,
  ariaAutoComplete,
  ariaControls,
  ariaDescribedBy,
  ariaExpanded,
  ariaLabel,
  ariaLabelledBy,
  ariaMultiline,
  ariaOwneeID,
  ariaRequired,
  autoCapitalize,
  autoComplete,
  autoCorrect,
  className,
  id,
  role = 'textbox',
  spellCheck = true,
  style,
  tabIndex,
  testid
}) {
  const [editor] = LexicalComposerContext.useLexicalComposerContext();
  const [isEditable, setEditable] = React.useState(false);
  const ref = React.useCallback(rootElement => {
    editor.setRootElement(rootElement);
  }, [editor]);
  useLayoutEffect(() => {
    setEditable(editor.isEditable());
    return editor.registerEditableListener(currentIsEditable => {
      setEditable(currentIsEditable);
    });
  }, [editor]);
  return /*#__PURE__*/React.createElement("div", {
    "aria-activedescendant": !isEditable ? null : ariaActiveDescendantID,
    "aria-autocomplete": !isEditable ? null : ariaAutoComplete,
    "aria-controls": !isEditable ? null : ariaControls,
    "aria-describedby": ariaDescribedBy,
    "aria-expanded": !isEditable ? null : role === 'combobox' ? !!ariaExpanded : null,
    "aria-label": ariaLabel,
    "aria-labelledby": ariaLabelledBy,
    "aria-multiline": ariaMultiline,
    "aria-owns": !isEditable ? null : ariaOwneeID,
    "aria-required": ariaRequired,
    autoCapitalize: autoCapitalize !== undefined ? String(autoCapitalize) : undefined // @ts-ignore This is a valid attribute
    ,
    autoComplete: autoComplete,
    autoCorrect: autoCorrect !== undefined ? String(autoCorrect) : undefined,
    className: className,
    contentEditable: isEditable,
    "data-testid": testid,
    id: id,
    ref: ref,
    role: !isEditable ? undefined : role,
    spellCheck: spellCheck,
    style: style,
    tabIndex: tabIndex
  });
}

exports.ContentEditable = ContentEditable;
