/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
'use strict';

var LexicalComposerContext = require('@lexical/react/LexicalComposerContext');
var react = require('react');

/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */
const CAN_USE_DOM = typeof window !== 'undefined' && typeof window.document !== 'undefined' && typeof window.document.createElement !== 'undefined';

/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */
const useLayoutEffectImpl = CAN_USE_DOM ? react.useLayoutEffect : react.useEffect;
var useLayoutEffect = useLayoutEffectImpl;

/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */
function NodeEventPlugin({
  nodeType,
  eventType,
  eventListener
}) {
  const [editor] = LexicalComposerContext.useLexicalComposerContext();
  const listenerRef = react.useRef(eventListener);
  listenerRef.current = eventListener;
  useLayoutEffect(() => {
    return editor.registerMutationListener(nodeType, mutations => {
      const registedElements = new WeakSet();
      editor.getEditorState().read(() => {
        for (const [key, mutation] of mutations) {
          const element = editor.getElementByKey(key);

          if ( // Updated might be a move, so that might mean a new DOM element
          // is created. In this case, we need to add and event listener too.
          (mutation === 'created' || mutation === 'updated') && element !== null && !registedElements.has(element)) {
            registedElements.add(element);
            element.addEventListener(eventType, event => {
              listenerRef.current(event, editor, key);
            });
          }
        }
      });
    }); // wW intentionally don't respect changes to eventType.
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [editor, nodeType]);
  return null;
}

exports.NodeEventPlugin = NodeEventPlugin;
