/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */
import type { GridSelection, LexicalEditor, LexicalNode, NodeSelection, Point, RangeSelection, TextNode } from 'lexical';
export declare function $cloneWithProperties<T extends LexicalNode>(node: T): T;
export declare function $sliceSelectedTextNodeContent(selection: RangeSelection | GridSelection | NodeSelection, textNode: TextNode): LexicalNode;
export declare function $isAtNodeEnd(point: Point): boolean;
export declare function trimTextContentFromAnchor(editor: LexicalEditor, anchor: Point, delCount: number): void;
export declare function $addNodeStyle(node: TextNode): void;
export declare function $patchStyleText(selection: RangeSelection | GridSelection, patch: Record<string, string | null>): void;
