/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */
import type { LexicalEditor, LexicalNode } from 'lexical';
export declare function createDOMRange(editor: LexicalEditor, anchorNode: LexicalNode, _anchorOffset: number, focusNode: LexicalNode, _focusOffset: number): Range | null;
export declare function createRectsFromDOMRange(editor: LexicalEditor, range: Range): Array<ClientRect>;
export declare function getStyleObjectFromRawCSS(css: string): Record<string, string>;
export declare function getStyleObjectFromCSS(css: string): Record<string, string>;
export declare function getCSSFromStyleObject(styles: Record<string, string>): string;
