/** @module @lexical/utils */
/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */
import { EditorState, ElementNode, Klass, LexicalEditor, LexicalNode } from 'lexical';
export declare type DFSNode = Readonly<{
    depth: number;
    node: LexicalNode;
}>;
export declare function addClassNamesToElement(element: HTMLElement, ...classNames: Array<typeof undefined | boolean | null | string>): void;
export declare function removeClassNamesFromElement(element: HTMLElement, ...classNames: Array<typeof undefined | boolean | null | string>): void;
export declare function isMimeType(file: File, acceptableMimeTypes: Array<string>): boolean;
/**
 * Lexical File Reader with:
 *  1. MIME type support
 *  2. batched results (HistoryPlugin compatibility)
 *  3. Order aware (respects the order when multiple Files are passed)
 *
 * const filesResult = await mediaFileReader(files, ['image/']);
 * filesResult.forEach(file => editor.dispatchCommand('INSERT_IMAGE', {
 *   src: file.result,
 * }));
 */
export declare function mediaFileReader(files: Array<File>, acceptableMimeTypes: Array<string>): Promise<Array<{
    file: File;
    result: string;
}>>;
export declare function $dfs(startingNode?: LexicalNode, endingNode?: LexicalNode): Array<DFSNode>;
export declare function $getNearestNodeOfType<T extends ElementNode>(node: LexicalNode, klass: Klass<T>): T | null;
export declare function $getNearestBlockElementAncestorOrThrow(startNode: LexicalNode): ElementNode;
export declare type DOMNodeToLexicalConversion = (element: Node) => LexicalNode;
export declare type DOMNodeToLexicalConversionMap = Record<string, DOMNodeToLexicalConversion>;
export declare function $findMatchingParent(startingNode: LexicalNode, findFn: (node: LexicalNode) => boolean): LexicalNode | null;
declare type Func = () => void;
export declare function mergeRegister(...func: Array<Func>): () => void;
export declare function registerNestedElementResolver<N extends ElementNode>(editor: LexicalEditor, targetNode: Klass<N>, cloneNode: (from: N) => N, handleOverlap: (from: N, to: N) => void): () => void;
export declare function $restoreEditorState(editor: LexicalEditor, editorState: EditorState): void;
export declare function $insertNodeToNearestRoot<T extends LexicalNode>(node: T): T;
export declare function $wrapNodeInElement(node: LexicalNode, createElementNode: () => ElementNode): ElementNode;
export declare function $splitNode(node: ElementNode, offset: number): [ElementNode | null, ElementNode];
export {};
