/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */
import type { EditorState, NodeKey } from 'lexical';
import { WebsocketProvider } from 'y-websocket';
import { Text as YText, YEvent } from 'yjs';
import { Binding } from '.';
export declare function syncYjsChangesToLexical(binding: Binding, provider: WebsocketProvider, events: Array<YEvent<YText>>): void;
declare type IntentionallyMarkedAsDirtyElement = boolean;
export declare function syncLexicalUpdateToYjs(binding: Binding, provider: WebsocketProvider, prevEditorState: EditorState, currEditorState: EditorState, dirtyElements: Map<NodeKey, IntentionallyMarkedAsDirtyElement>, dirtyLeaves: Set<NodeKey>, normalizedNodes: Set<NodeKey>, tags: Set<string>): void;
export {};
