/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */
import type { EditorConfig, LexicalEditor } from './LexicalEditor';
import type { RangeSelection } from './LexicalSelection';
import { ElementNode } from '.';
export declare type NodeMap = Map<NodeKey, LexicalNode>;
export declare type SerializedLexicalNode = {
    type: string;
    version: number;
};
export declare function removeNode(nodeToRemove: LexicalNode, restoreSelection: boolean, preserveEmptyParent?: boolean): void;
export declare type DOMConversion<T extends HTMLElement = HTMLElement> = {
    conversion: DOMConversionFn<T>;
    priority: 0 | 1 | 2 | 3 | 4;
};
export declare type DOMConversionFn<T extends HTMLElement = HTMLElement> = (element: T, parent?: Node, preformatted?: boolean) => DOMConversionOutput | null;
export declare type DOMChildConversion = (lexicalNode: LexicalNode, parentLexicalNode: LexicalNode | null | undefined) => LexicalNode | null | undefined;
export declare type DOMConversionMap<T extends HTMLElement = HTMLElement> = Record<NodeName, (node: T) => DOMConversion<T> | null>;
declare type NodeName = string;
export declare type DOMConversionOutput = {
    after?: (childLexicalNodes: Array<LexicalNode>) => Array<LexicalNode>;
    forChild?: DOMChildConversion;
    node: LexicalNode | null;
    preformatted?: boolean;
};
export declare type DOMExportOutput = {
    after?: (generatedElement: HTMLElement | null | undefined) => HTMLElement | null | undefined;
    element: HTMLElement | null;
};
export declare type NodeKey = string;
export declare class LexicalNode {
    [x: string]: any;
    /** @internal */
    __type: string;
    /** @internal */
    __key: string;
    /** @internal */
    __parent: null | NodeKey;
    /** @internal */
    __prev: null | NodeKey;
    /** @internal */
    __next: null | NodeKey;
    static getType(): string;
    static clone(_data: unknown): LexicalNode;
    constructor(key?: NodeKey);
    getType(): string;
    isAttached(): boolean;
    isSelected(): boolean;
    getKey(): NodeKey;
    getIndexWithinParent(): number;
    getParent<T extends ElementNode>(): T | null;
    getParentOrThrow<T extends ElementNode>(): T;
    getTopLevelElement(): ElementNode | this | null;
    getTopLevelElementOrThrow(): ElementNode | this;
    getParents(): Array<ElementNode>;
    getParentKeys(): Array<NodeKey>;
    getPreviousSibling<T extends LexicalNode>(): T | null;
    getPreviousSiblings<T extends LexicalNode>(): Array<T>;
    getNextSibling<T extends LexicalNode>(): T | null;
    getNextSiblings<T extends LexicalNode>(): Array<T>;
    getCommonAncestor<T extends ElementNode = ElementNode>(node: LexicalNode): T | null;
    is(object: LexicalNode | null | undefined): boolean;
    isBefore(targetNode: LexicalNode): boolean;
    isParentOf(targetNode: LexicalNode): boolean;
    getNodesBetween(targetNode: LexicalNode): Array<LexicalNode>;
    isDirty(): boolean;
    getLatest(): this;
    getWritable(): this;
    getTextContent(): string;
    getTextContentSize(): number;
    createDOM(_config: EditorConfig, _editor: LexicalEditor): HTMLElement;
    updateDOM(_prevNode: unknown, _dom: HTMLElement, _config: EditorConfig): boolean;
    exportDOM(editor: LexicalEditor): DOMExportOutput;
    exportJSON(): SerializedLexicalNode;
    static importJSON(_serializedNode: SerializedLexicalNode): LexicalNode;
    remove(preserveEmptyParent?: boolean): void;
    replace<N extends LexicalNode>(replaceWith: N, includeChildren?: boolean): N;
    insertAfter(nodeToInsert: LexicalNode, restoreSelection?: boolean): LexicalNode;
    insertBefore(nodeToInsert: LexicalNode, restoreSelection?: boolean): LexicalNode;
    selectPrevious(anchorOffset?: number, focusOffset?: number): RangeSelection;
    selectNext(anchorOffset?: number, focusOffset?: number): RangeSelection;
    markDirty(): void;
}
export {};
