<div>
    <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center py-4">
        <div class="d-block mb-4 mb-md-0">
            <nav aria-label="breadcrumb" class="d-none d-md-inline-block">
                <ol class="breadcrumb breadcrumb-dark breadcrumb-transparent">
                    <li class="breadcrumb-item">
                        <a href="#">
                            <svg class="icon icon-xxs" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                <path
                                    stroke-linecap="round"
                                    stroke-linejoin="round"
                                    stroke-width="2"
                                    d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"
                                ></path>
                            </svg>
                        </a>
                    </li>
                    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{ env('APP_NAME') }}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{ __('Language List') }}</li>
                </ol>
            </nav>
            <h2 class="h4">{{ __('Language Data Update') }}</h2>
            <p class="mb-0">{{ __('Show All Language Data Update') }}</p>
        </div>
        <div class="btn-toolbar mb-2 mb-md-0">
            <a href="{{ route('admin.lang.create') }}" class="btn btn-sm btn-gray-800 d-inline-flex align-items-center">
                <svg class="icon icon-xs me-2" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                </svg>
                {{ __('New Language') }}
            </a>
        </div>
    </div>
    
    <div class="card card-body shadow border-0 table-wrapper table-responsive">
        <form wire:submit.prevent="customize">
            
            <table class="table user-table table-hover align-items-center">
                <thead>
                    <tr>
                        <th class="border-bottom">{{ __('Key') }}</th>
                        <th class="border-bottom">{{ __('Value') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($langs as $key=>$lang)
                    <tr>
                        <td> 
                            <span class="fw-bold">{{ $key }}</span>
                        </td>
                        
                        <td> <input type="text" class="form-control" wire:model="value.{{ $lang }}"></td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
            <div class="float-right mt-3">
                <button type="submit" class="btn btn-primary">{{ __('Save & Update') }}</button>
            </div>
        </form>
    </div>
</div>


<script src="{{ asset('assets/js/script.js') }}"></script>